#############################################################################
# LFS TeamChat by Krayy
#############################################################################
# This script enables the !tc command that can be used to chat among teams.
# A team is denoted by the Racer Tag, which must be of the format:
#
# 	[<team name>]<Racer Namer>
#
# Where the team name is at the beginning of the Tag and is surrounded by a 
# pair of square brackets. Future versions may make this customisable at the
# command line.
#############################################################################
# Ver 1.0.0 - 07 Jan 2011 - Initial release
# Ver 1.0.1 - 08 Jan 2011 - Fixed bug where team name brackets are not in order
#############################################################################

CatchEvent OnLapperStart()
	# Set TeamChat globals
	GlobalVar $tcDelimiterStart;
	GlobalVar $tcDelimiterEnd;
	
	# Set the inital values to be square brackets
	$tcDelimiterStart = "[";
	$tcDelimiterEnd = "]";
EndCatchEvent

CatchEvent OnConnect( $userName ) # Player event
	 SetTeamName();
EndCatchEvent

CatchEvent OnNameChange($userName,$oldNickName,$newNickName) # Player event
	 SetTeamName();
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) 
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!tc":
				TeamChat($argv);
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub SetTeamName ( )
	$NickName = GetCurrentPlayerVar("NickName");
	$NickStrip = StripLFSColor( ToLower($NickName) );  
	$IdxStart = indexOf( $NickStrip , $tcDelimiterStart);  
	$IdxEnd = indexOf( $NickStrip , $tcDelimiterEnd);  

	IF ( $IdxStart == -1 || $IdxEnd == -1 )
	THEN
		$MyTeam = "";
	ELSE
		IF ( $IdxStart > $IdxEnd )
		THEN
			$MyTeam = "";
		ELSE
			$MyTeam = subStr( $NickStrip ,$IdxStart + 1, ($IdxEnd - $IdxStart) - 1  );
		ENDIF
	ENDIF
	
	IF ( $MyTeam == "" )
	THEN
		privMsg ("^7I am unable to find a valid Team Name in your NickName...");
		privMsg ("^7A Team name should be bracketed with a ^3" . $tcDelimiterStart . "^7 and a ^3" . $tcDelimiterEnd);
	ELSE
		privMsg ("^7Your Name shows that you are in Team: ^3" . $MyTeam);
	ENDIF
	SetCurrentPlayerVar("TeamName",$MyTeam);
EndSub

Sub TeamChat ( $msg )
	$NickName = GetCurrentPlayerVar("NickName");
	$MyTeam = GetCurrentPlayerVar("TeamName");
	IF ( $MyTeam != "" )
	THEN
		$lop = GetListOfPlayers("N");
		FOREACH ( $de in $lop )
			$userName = $de["value"];
			IF ( GetPlayerVar($userName,"TeamName") == $MyTeam )
			THEN
				privMsg ( $userName, "^5TeamChat from ^8" . $NickName . "^5: ^8");
				privMsg ( $userName, "^6" . $msg );
			ENDIF
		ENDFOREACH
	ELSE
		privMsg ("You must have your Team name in your Nick to use TeamChat!");
	ENDIF
EndSub
